/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/



#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <l4/kdebug.h>

#include <thread.h>

#define PAGEMASK 0x1fff

qword_t timeout_stack [1024];

qword_t _pager1_stack[2048];
qword_t _taskA_stack[2048];
qword_t _taskB_stack[2048];

qword_t _pagerA_stack[2048];
qword_t _taskAA_stack[2048];
qword_t _taskA_A_stack[2048];

struct _flexpage_msg {
  qword_t rcv_flexpage;
  qword_t size_dope;
  qword_t send_dope;
  qword_t pl, ph;
};

volatile char *memory = (char *)0;
long int runsp = 0x800000;
long int oldsp;

struct _flexpage_msg flexpage_msg = {
  0,
  (1 << 14) | (0 << 8),
  (1 << 14) | (0 << 8),
  0x0000000000000000,
  0x0000000002000034,
};

void taskA(void);
void taskB(void);
void pager1(void);
void taskAA(void);

#define NEW1	3
#define NEW2	102
#define NEW3    103
#define NEW4    104

void taskA_A(void);

inline void l4_grant_task (l4_threadid_t task, l4_taskid_t destination)
{
  l4_task_new (task, destination.thread_id, 0, 0, L4_NIL_ID);
}

/* root_main8() */
int main (void) 
{
  l4_threadid_t ms, pager, from;
  l4_taskid_t taskA_tid, taskB_tid, taskAA_tid;
  
//  l4_ipcregs_t regs;  
  l4_msgdope_t result;

#if 0
  l4_threadid_t tmpPager, tmpPreempter, tmpMyself;
  qword_t dummy;

  tmpPager = tmpPreempter = L4_INVALID_ID;
  tmpMyself = l4_myself();
#endif

  print_string("\n\rMain: Hi\n\r");
  ms = pager = taskA_tid = taskB_tid = taskAA_tid = l4_myself();
  print_hex(l4_myself().thread_id,64);
  print_string("\n\r");


#if 0
  l4_thread_ex_regs (tmpMyself/*.id.lthread*/, (qword_t)-1, (qword_t)-1, 
                     &tmpPreempter, &tmpPager, &dummy, &dummy);

  print_string("\n\rPAGER:");
  print_hex(tmpPager.ID, 64);
  print_string(".\n\r");

  enter_kdebug();
#endif


  pager.id.lthread = 10;

  /* Create our pager thread */
  CreateThread(10, 0, pager1, &_pager1_stack[2047], (void*)10);

  taskB_tid.id.chief = taskA_tid.id.chief = NEW1;
  taskA_tid.id.task = NEW2;
  taskB_tid.id.task = NEW3;

  /* Give taskA the permission to create taskAA */
  taskAA_tid.id.task = NEW4;
  l4_grant_task(taskAA_tid, taskA_tid);

  /* Create a couple of tasks */
  l4_task_new (taskA_tid, 0xf0, &_taskA_stack[2047], taskA, pager);
  l4_task_new (taskB_tid, 0xf0, &_taskB_stack[2047], taskB, pager);

  print_string("Main: Created new tasks\n\r");
  
//  l4_alpha_ipc_wait(&from, 

  while(1) {
	l4_alpha_ipc_wait (&from,
			   NULL,
			   NULL,
			   L4_IPC_NEVER, &result);

	print_string("MAIN: Intercepted (Recvd) message from \n\r");
	print_hex(from.thread_id,64);

	enter_kdebug();

    }


  while(1);

}

void taskA(void) {
    l4_threadid_t pagerA, taskB_tid, taskAA_tid, taskA_A_tid, from, real_dest;
    l4_msgdope_t result;
    
    print_string("\n\rTaskA: Hi");
    print_hex(l4_myself().thread_id,64);
    print_string("\n\r");

    taskAA_tid = pagerA = l4_myself();
    pagerA.id.lthread = 10;

    taskB_tid.thread_id = 0x1006000003380001; /*0x1004000003380001;*/

    print_string("taskA: I expect pagerA to be:");
    print_hex(pagerA.thread_id, 64);
    print_string("\n\r");

    /* Create our pager thread */
    CreateThread(10, 0, pager1, &_pagerA_stack[2047], (void*)10);
    taskAA_tid.id.chief = NEW2;
    taskAA_tid.id.task = NEW4;

    print_string("taskA: I expect taskAA_tid (approx) to be:");
    print_hex(taskAA_tid.thread_id, 64);
    print_string("\n\r");


    l4_task_new(taskAA_tid, 0xf0, &_taskAA_stack[2047], taskAA, pagerA);



    /* ok, this test should be out of the loop.. */
    taskA_A_tid = l4_myself();
    taskA_A_tid.id.lthread = 20;
    
    CreateThread(taskA_A_tid.id.lthread, 0, taskA_A, 
		 &_taskA_A_stack[2047], (void*)taskA_A_tid.id.lthread);

    print_string("@");
    
    l4_alpha_ipc_send_deceiting(taskA_A_tid, taskAA_tid, 1, NULL,
				L4_IPC_NEVER, &result);
    print_string("''");

    /* we can expect to be redirecting messages here */
    /* currently, because we have NO idea who they are destined to, we make
     * the assumption that they are from taskB to taskAA
     */

    while(1) {
/*	l4_alpha_ipc_wait (&from,
			   NULL,
			   NULL,
			   L4_IPC_NEVER, &result);
*/
      l4_alpha_ipc_chief_wait (&from,
			       &real_dest,
			       NULL,
			       NULL,
			       L4_IPC_NEVER, &result);

      print_string("RealDest"); print_hex(real_dest.thread_id, 64);
      print_string("A: chief_wait mdope:");
      print_hex (result.msgdope, 64);

	if(from.id.task == NEW3) {
	    print_string("TaskA: Deceiting Intercepted (Recvd) message from taskB\n\r");
//	    l4_alpha_ipc_send (taskAA_tid,
//			       NULL, NULL, L4_IPC_NEVER, &result);
	    // want it to look like taskB_tid sent it (which it did)...

	    // sleep here so that receiver will be waiting..
	    l4_alpha_ipc_receive (l4_myself(),
				  NULL, NULL, 
				  L4_IPC_TIMEOUT (0,0, 325000, 1,0,0),&result);

	    print_string("`");
	    l4_alpha_ipc_send_deceiting (taskAA_tid, taskB_tid,	     
					 1, NULL, L4_IPC_NEVER, &result);
	    print_string("'");

	

	}
	else 
	    print_string("TaskA: Culled message from unknown\n\r");
    }

    while(1);

}

void taskA_A(void) {
    l4_threadid_t from;
    l4_msgdope_t result;
    /* Another thread in taskA */
    print_string("taskA_A ALIVE\n\r");

    l4_alpha_ipc_wait(&from, NULL, NULL, L4_IPC_NEVER, &result);
    print_string("taskA_A received.\n\r");

    while(1);
}


void taskB(void) {
    l4_threadid_t taskB_tid, taskAA_tid, taskA_tid;
    l4_msgdope_t result;
    l4_threadid_t from;
    int r;

    print_string("\n\rTaskB: Hi ");
    print_hex(l4_myself().thread_id,64);
    print_string("\n\r");

    taskA_tid.thread_id = 0x1006000003300001; /*0x1004000003300001;*/
    taskB_tid.thread_id = 0x1006000003380001; /*0x1004000003380001;*/
    taskAA_tid.thread_id = 0x18cc000003400001; /*0x10cc000003400001;*//*0x18cc000003400001;*/

    l4_alpha_ipc_receive (l4_myself(),
			  NULL, NULL, 
			  L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
    l4_alpha_ipc_receive (l4_myself(),
			  NULL, NULL, 
			  L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
    l4_alpha_ipc_receive (l4_myself(),
			  NULL, NULL, 
			  L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);



    r = l4_id_nearest(taskAA_tid, &from);
    print_string("taskB: direction of taskAA: ");
    print_hex(r,16);
    print_string("\n\rtaskB: intercepting: ");
    print_hex(from.thread_id,64);
    print_string("\n\r");

    r = l4_id_nearest(taskA_tid, &from);
    print_string("taskB: direction of taskA: ");
    print_hex(r,16);
    print_string("\n\rtaskB: intercepting: ");
    print_hex(from.thread_id,64);
    print_string("\n\r");
    
    l4_alpha_ipc_send (taskAA_tid,
		       NULL, NULL, L4_IPC_NEVER, &result);
    print_string("B: send mdope:");
    print_hex (result.msgdope, 64);

    print_string("*\n\r");
    l4_alpha_ipc_send (taskAA_tid,
		       NULL, NULL, L4_IPC_NEVER, &result);
    print_string("B: send mdope:");
    print_hex (result.msgdope, 64);
    print_string("*\n\r");
//        l4_alpha_ipc_wait(&from, NULL, NULL, L4_IPC_NEVER, &result);
//        print_string("ping");


    while(1);

}


void taskAA(void) {
    l4_msgdope_t result;
    l4_threadid_t from;
    l4_threadid_t taskB_tid, taskA_tid;

    print_string("\n\rTaskAA: Hi");
    print_hex(l4_myself().thread_id,64);
    print_string("\n\r");

    taskB_tid.thread_id = 0x1006000003380001; /*0x1004000003380001;*/
    taskA_tid.thread_id = 0x1006000003300001; /*0x1004000003300001;*/

    l4_alpha_ipc_receive (l4_myself(),
			  NULL, NULL, 
			  L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
    
    l4_alpha_ipc_wait (&from,
			  NULL, NULL, L4_IPC_NEVER, &result);
    print_string("AA: wait mdope:");
    print_hex (result.msgdope, 64);
    print_string("#\n\r");
    print_string("\n\rTaskAA: from ");
    print_hex(from.thread_id,64);
    /* testing receive - expect from taskB, we are doing a direct wait to test
     * the syscall here. 
     */

    l4_alpha_ipc_receive (from, /* task B */
			  NULL, NULL, L4_IPC_NEVER, &result);
    print_string("AA: recv mdope:");
    print_hex (result.msgdope, 64);
    print_string("#\n\r");
    print_string("\n\r2TaskAA: from ");
    print_hex(from.thread_id,64);
//        l4_alpha_ipc_send(taskB_tid, NULL, NULL, L4_IPC_NEVER, &result);
//        print_string("pong");
    
    /* Now we want to send a message to taskA_A */
    //l4_alpha_ipc_send(taskA_A, NULL, NULL, L4_IPC_NEVER, &result);
    //print_string("\n\rTASKAA: Send TO A_A done\n\r");


    while(1);

}


void pager1(void) {
    l4_threadid_t ms, pager, from,  oid;
    l4_ipcregs_t regs;  
    l4_msgdope_t result;
    qword_t old;
    char d;

    ms = l4_myself();
    print_string("Pager1: G'day I'm Pager1 ");
    print_hex(l4_myself().thread_id,64);
    print_string("\n\r");

    l4_alpha_ipc_wait (&from,
		       NULL,
		       &regs,
		       L4_IPC_NEVER, &result);
  
  while (1) {

      print_string("Pager1: Received req, dope =");
      print_hex(result.msgdope,64);
      print_string("Pager1: From.");
      print_hex(from.thread_id,64);

      if ((regs.val[0] == old) && (oid.id.task == from.id.task)) {
	  print_string ("P1:Got addr 2 times\n\rAddr "); print_hex (old, 64); 
	  print_string (";  IP = "); print_hex (regs.val[1], 64);
	  print_string ("\n\rP1:Faulting Thread is ");
	  print_hex (oid.thread_id, 64); print_string ("\n\r");
      }
      old = regs.val[0]; oid = from;
      d +=memory[regs.val[0]];
      regs.val[0] = 
	  regs.val[1] = ((regs.val[0]) & ~PAGEMASK) | (13 << 2) | 1;
//      print_string ("P1: Addr "); print_hex (regs.val[0], 64); 

      l4_alpha_ipc_reply_and_wait (from,
				 (void*)((qword_t)(NULL) | 0x02),
				 &regs,
				 &from,
				 NULL,
				 &regs,
				 L4_IPC_NEVER, &result);
    if (L4_IPC_IS_ERROR(result)) {
	print_string ("P1: Cannot send, why ?\n\r");
	print_hex (result.msgdope, 64);
    }

  }

  print_string("P1: I SHOULDNT GET HERE\n\r");

  enter_kdebug ();
  while (1);

}

        


void timeout_thread (void)
{
    l4_msgdope_t result;

    l4_alpha_ipc_receive (l4_myself(), NULL, NULL, 
			  L4_IPC_TIMEOUT (0, 0, 62500, 1, 0,0),&result);
    print_string ("Emergency Timeout\n");
    enter_kdebug ();
    halt();
}




