#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <l4/kdebug.h>

#include <thread.h>

/* This is a simple test for deceit to fix a bug when sending directly to
   someone in your own clan - most specifically in your own task.
*/


qword_t threadB_stack[1024];


void threadB(void);

#define THREADB		10;

void main(void) {
    l4_threadid_t threadB_tid, from, dummy_task;
    l4_msgdope_t result;
    int r;

    threadB_tid = dummy_task = l4_myself();
    threadB_tid.id.lthread = THREADB;
    
    dummy_task.id.task++;

    print_string("MAIN: Creating thread\n\r");
    print_hex(l4_myself().ID,64);

    CreateThread(10, 0, threadB, &threadB_stack[1023], (void*)10);

    print_string("MAIN: Sending normal message to thread\n\r");

    l4_alpha_ipc_send(threadB_tid, NULL, NULL, L4_IPC_NEVER, &result);
    l4_alpha_ipc_wait(&from, NULL, NULL, L4_IPC_NEVER, &result);

    r = l4_id_nearest(threadB_tid, &from);
    print_string("MAIN: direction of threadB: ");
    print_hex(from.thread_id,64);
    print_string(" r:");
    print_hex(r,32);
    r = l4_id_nearest(dummy_task, &from);
    print_string("\n\rMAIN: direction of dummy_task: ");
    print_hex(from.thread_id,64);
    print_string(" r:");
    print_hex(r,32);

    print_string("\n\rMAIN: Sending deceit message to thread\n\r");

    l4_alpha_ipc_send_deceiting(threadB_tid, dummy_task, NULL, NULL, 
				L4_IPC_NEVER, &result);

    print_string("MAIN: Send done\n\r");

    while(1);
}

void threadB(void) {
    l4_threadid_t from;
    l4_msgdope_t result;

    print_string("TB: Hi\n\r");
    print_hex(l4_myself().ID,64);

    while(1) {
	l4_alpha_ipc_wait(&from, NULL, NULL, L4_IPC_NEVER, &result);
	print_string("\n\rTB: Received msg.\n\r");
	l4_alpha_ipc_send(from, NULL, NULL, L4_IPC_NEVER, &result);
	print_string("\n\rTB: Msg sent\n\r");
    }
}
