/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/



#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <l4/kdebug.h>

qword_t timeout_stack [1024];

struct _flexpage_msg {
  qword_t rcv_flexpage;
  qword_t size_dope;
  qword_t send_dope;
  qword_t pl, ph;
};


struct _flexpage_msg flexpage_msg = {
  0,
  (1 << 14) | (0 << 8),
  (1 << 14) | (0 << 8),
  0x0000000000000000,
  0x0000000002000034,
};


#define NEW1	123
#define NEW2	1020

inline void l4_grant_task (l4_threadid_t task, l4_taskid_t destination)
{
  l4_task_new (task, destination.thread_id, 0, L4_NIL_ID);
}


void root_main9 (void)
{
  l4_threadid_t ms, pager, preempter, from;
  l4_taskid_t tid;
  qword_t dummy;
  l4_ipcregs_t regs;  

  print_hex (l4_myself().thread_id, 64);
  print_string (" is a new task NEW2\n\r");

  enter_kdebug();
  while (1);
}


void root_main8 (void) 
{
  l4_threadid_t ms, pager, preempter, from;
  l4_taskid_t tid;
  qword_t dummy;
  l4_ipcregs_t regs;  
  l4_msgdope_t result;

  ms = tid = l4_myself();

  print_hex (l4_myself().thread_id, 64);
  print_string (" is a new task\n\r");

  print_string ("Create New Task NEW2\n\r");

  tid.id.task = NEW2;
  l4_task_new (tid, 0, 0x220000, ms);

  print_string ("Task NEW1 is requesting page faults\n\r");

  while (1) {
    l4_alpha_ipc_wait (&from,
		       NULL,
		       &regs,
		       L4_IPC_NEVER,&result);
    print_string ("Request task NEW1 from ");print_hex(from.thread_id, 64);
    print_string (" address : ");print_hex(regs.val[0],64);
    print_string (".\n\r");
    
    flexpage_msg.pl = 
      flexpage_msg.ph = (regs.val[0] & ~0x1fff) | (13 << 2) | 1;

    l4_alpha_ipc_send (from,
		       (void*)((qword_t)(&flexpage_msg) | 0x02),
		       NULL,
		       L4_IPC_NEVER, &result);
    print_string ("Flexpage replyed taskNEW1\n\r");
  }

  enter_kdebug ();
  while (1);
}

        


void timeout_thread (void)
{
  l4_msgdope_t result;
  l4_alpha_ipc_receive (l4_myself(),
		    NULL, NULL, L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
  print_string ("Emergency Timeout\n");
  enter_kdebug ();
  halt();
}
  


int main (void)
{
    l4_threadid_t ms, pager, preempter, from;
  l4_taskid_t tid, des;
  qword_t dummy;
  l4_ipcregs_t regs;  
  l4_msgdope_t result;


  ms = tid = l4_myself();
  if (tid.id.task == NEW1) {
    root_main8 ();
  } else
  if (tid.id.task == NEW2) {
    root_main9 ();
  }

  print_string ("Create New Task NEW1\n\r");

  
  tid.id.task = NEW1;

  /* Set new - rights for task 8 to create task 9 */
  des = tid;
  des.id.task = NEW2;
  l4_grant_task (des, tid);

  l4_task_new (tid, 0, 0x220000, ms);

  preempter = pager = L4_INVALID_ID;
  l4_thread_ex_regs (2, 
		     (qword_t)&timeout_thread, (qword_t)(&timeout_stack[1023]), 
		     &preempter, &pager, &dummy, &dummy);


  print_string ("Sigma 0 is requesting page faults\n\r");

  while (1) {
    l4_alpha_ipc_wait (&from,
		       NULL,
		       &regs,
		       L4_IPC_NEVER, &result);
    print_string ("Request sigma0 from ");print_hex(from.thread_id, 64);
    print_string (" address : ");print_hex(regs.val[0],64);
    print_string (".\n\r");
    
    flexpage_msg.pl = 
      flexpage_msg.ph = (regs.val[0] & ~0x1fff) | (13 << 2) | 1;

    l4_alpha_ipc_send (from,
		       (void*)((qword_t)(&flexpage_msg) | 0x02),
		       NULL,
		       L4_IPC_NEVER, &result);
    print_string ("Flexpage replyed sigma0\n\r");
  }
}






