/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/

#include <l4/types.h>
#include <l4/syscalls.h>

#include <l4/kdebug.h>

void __memory(void);
void __instruction(void);
void __arithmetic(void);
void __unaligned (void);

l4_alphaidt_t idt = {
  __memory,
  __instruction,
  __arithmetic,
  __unaligned
};
  


/* 
** The head.S file sets up a stack and jumps here 
*/
int main (void)
{
  l4_threadid_t myself;

  l4_set_idt (&idt);
  
  print_string ("Raise unaligned exception 5 times\n\r");
  __asm__ ("ldq	$0, 2($30)\n");
}


void unaligned_trap (void)
{
  static int i = 5;
  
  if (i--) {
    print_string ("User level unaligned access\n\r");
    return;
  }
  enter_kdebug ();
}

void instruction_trap (void)
{
}

void arithemtic_trap (void)
{
}

void memory (void)
{
}
