/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/



#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <l4/kdebug.h>


void _error_proc (void);

void outb (const int port, const int x)
{
  int *pw = (int *)(0x00008580000000 + (port << 5));  
  register int w = (x & 0xff) << (8 * (port & 0x03));

  *pw = w;
}

int inb (const int port)
{
  int *pw = (int *)(0x00008580000000 + (port << 5));  

  return (*pw >> (port & 0x03)) & 0xff;
}

volatile int assoc = 0;
qword_t _irq_stack [1024];  

l4_threadid_t myirq (void)
{
  return (l4_threadid_t){thread_id:21};
}

void kbd_write (int p, int d)
{
	int status;

	do {
		status = inb(0x64);  /* spin until input buffer empty*/
	} while (status & 2);
	outb(p, d);
}
  

void irq_thread (void)
{
  l4_taskid_t tid;
  l4_msgdope_t ret;
  l4_ipcregs_t regs;
  qword_t dummy, pc, sp;
  int x;
  l4_threadid_t preempter, pager;

  enter_kdebug();

  print_string ("returned from kdebug\n\r");

  tid.thread_id = 0x80 | myirq().thread_id;
  l4_alpha_ipc_receive (tid, NULL, &regs, L4_IPC_TIMEOUT (0, 0, 62500, 1, 0, 0));

  outb (0x21, 0x00);
  kbd_write (0x64, 0xae);
  kbd_write (0x64, 0x60);
  
  kbd_write (0x60, 0x65);

  print_string ("Interrupt associated ?\n\r");

  assoc = 1;
  print_string ("Press SPACE to exit\n\r");
  while (1) {
    print_string ("Wait for irq \r");
    ret = l4_alpha_ipc_receive (myirq(), NULL, &regs, L4_IPC_NEVER);
    if (ret.msgdope == 0) {
      print_hex ((x = inb (0x60)), 8);
      print_string (" pressed    \n\r");
      outb (0x20, 0x20);
      if (x == 0x39) {
        print_string ("Space pressed\n\r ");
	preempter = pager = L4_INVALID_ID;
	l4_thread_ex_regs (0, -1, -1, &preempter, &pager, &pc, &sp);
	print_string ("Thread 0 pc = "); print_hex (pc, 64);
	print_string (" Thread 0 sp = "); print_hex (sp, 64);
	print_string ("\n\r");
	l4_thread_ex_regs (0, (qword_t)(&_error_proc), sp, &preempter, &pager, &pc, &sp);
	while (1);
      }
    } else {
      print_string ("IRQ Receive Error\n\r");
      print_hex (ret.msgdope, 64);
      enter_kdebug ();
    }
  }
}

__asm__ ("
	 .text			\n
	 .globl _error_proc	\n
       _error_proc:		\n
	 br	$27, 1f		\n
       1:ldgp	$29, 0($27)	\n
	 lda	$27, error_proc \n
	 mov    $0, $16		\n
	 br	error_proc	\n");
	
void error_proc (qword_t ipc_error)
{
  print_hex (ipc_error, 8);
  print_string (" - Error Proc from l4_thread_ex_regs\n\r");
  enter_kdebug();
}

int main (void)
{
  l4_threadid_t ms, preempter, pager, from;
  volatile qword_t dummy, i;

  print_string ("Main\n\r");
  ms = l4_myself();

  preempter = pager = L4_INVALID_ID;

  /* Startup thread 2 */
  l4_thread_ex_regs (2, 
		     (qword_t)&irq_thread, (qword_t)(&_irq_stack[1023]), 
		     &preempter, &pager, &dummy, &dummy);


  from = ms;
  l4_alpha_ipc_receive (from, NULL, NULL, L4_IPC_NEVER);
}





