/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/



#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <l4/kdebug.h>

#include <thread.h>

volatile char *memory  = (char *)0;

        
void thread_start (void);
void test_thread1 (void);
void test_thread2 (void);


volatile l4_threadid_t ping = {thread_id:0};
volatile l4_threadid_t pong = {thread_id:0};
volatile long pingpongs = 0;

qword_t _thread_stack1 [1024];
qword_t _thread_stack2 [1024];


void delay (l4_timeout_t timeout) 
{
  l4_alpha_ipc_receive (l4_myself(),
		    NULL, NULL, timeout);
}


volatile unsigned long locked = 0;


void lock (void)
{
/*  while (locked); */
  locked = 1;
}

void unlock (void)
{
  locked = 0;
}


void test_thread1 (void)
{
  lock (); {
    print_string ("Myself id 2 = ");
    ping = l4_myself();
    print_hex (ping.thread_id, 64);
    print_string ("\r\n");
  } unlock ();

  print_string ("Thread1: waiting for pong..\n\r");


//  delay (L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0));

  while (!pong.thread_id)
      nop();
/*    l4_thread_switch (L4_NIL_ID);*/

  print_string ("\n\rStart ping thread\n\r");
  print_hex (pong.thread_id, 64);

  /* we need to interleave ping and pong call operation */
  l4_alpha_ipc_receive (pong,
			NULL,
			NULL,
			L4_IPC_NEVER);

  while (1) {
    l4_alpha_ipc_call (pong,
		       NULL,
		       NULL,
		       NULL,
		       NULL,
		       L4_IPC_NEVER);
  }



}



void test_thread2 (void)
{
  l4_msgdope_t re;
  
  lock (); {
    print_string ("Myself id 3 = ");
    pong = l4_myself();
    print_hex (pong.thread_id, 64);
    print_string ("\r\n");
  } unlock ();

  print_string ("Thread2 wait for ping...\n\r");

  while (!ping.thread_id) 
      nop();
/*    l4_thread_switch (L4_NIL_ID);*/

  print_string ("\n\rStart pong thread\n\r");
  print_hex (ping.thread_id, 64);

  while (1) {
    re = l4_alpha_ipc_call (ping,
			    NULL,
			    NULL,
			    NULL,
			    NULL,
			    L4_IPC_NEVER);
    if (L4_IPC_IS_ERROR(re)) {
      print_string ("error\n\r");
    }
    pingpongs ++;
  }

}



int main (void)
{
  l4_threadid_t ms, pager, preempter;
  l4_taskid_t tid;
  qword_t dummy;
  char d;

  l4_threadid_t from;
  l4_ipcregs_t regs; 

  print_string ("Main\n\r");
  ms = tid = l4_myself();

  preempter = pager = L4_INVALID_ID;


//  delay (L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0));

/*

  l4_thread_ex_regs (ms.id.lthread, (qword_t)-1, (qword_t)-1, 
                     &preempter, &pager, &dummy, &dummy);
		     

  l4_thread_ex_regs (2, 
		     (qword_t)&test_thread1, (qword_t)(&_thread_stack1[1023]), 
		     &preempter, &pager, &dummy, &dummy);

  print_string ("Creating second thread\n\r");

  l4_thread_ex_regs (3, 
		     (qword_t)&test_thread2, (qword_t)(&_thread_stack2[1023]), 
		     &preempter, &pager, &dummy, &dummy);
*/

  CreateThread(2+5, 0, test_thread1, &_thread_stack1[1023], (void*)2+5);
//  delay (L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0));
  print_string("Back from sleeeping\n\r");
  CreateThread(3+5, 0, test_thread2, &_thread_stack2[1023], (void*)3+5);

  print_string ("Threads created....\n\r");


/*  while(1) {
      print_string("T");
  }
*/

  /* Set receive timeout == (6250 * 16^1) = 100.000*0.1us = 10s */
  delay (L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0));

  print_hex (pingpongs, 64);
  print_string ("call-ipc untile Main loop timeout\n");
  enter_kdebug ();
  return 0;
}



