/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/

#define VU_DEBUG

#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <l4/kdebug.h>
#define TASK_COUNT   10
#define LEVEL_COUNT  10
#define MAX_FLUSH    4

qword_t timeout_stack [1024];
qword_t flush_stack [1024*MAX_FLUSH*LEVEL_COUNT];
qword_t hinundher_stack [2048];


#define NEW_PAGER      5	
#define NEW_TOUCHER    NEW_PAGER+LEVEL_COUNT+1	

volatile char *memory  = (char *)0;
void flush_thread();

inline void l4_grant_task (l4_threadid_t task, l4_taskid_t destination)
{
  l4_task_new (task, destination.thread_id, 0, L4_NIL_ID);
}

long int runsp = 0x800000;


void root_toucher (void)
{
  l4_threadid_t ms, pager, preempter, from;
  l4_taskid_t tid;
  qword_t dummy;
  char d;
  l4_ipcregs_t regs;  
  int i;

/*
  print_hex (l4_myself().thread_id, 64);
  print_string (" is a new TOUCH-task \n\r");
*/
  print_string ("$ ");
  while(1) {
    for (i = 0x400000; i < 0x500000; i+= 0x2000) {
 	  d+=memory[i];	
    }
    print_string("-");
#if 0
    for (i = 0; i < 50; i++)
	 l4_thread_switch (L4_NIL_ID);
#else
    l4_alpha_ipc_receive (l4_myself(),
		       NULL, NULL, L4_IPC_TIMEOUT (0, 0, 625, 1, 0,0));
#endif
  /*  break; */
  }
  
  while (1);
}


void root_pager (void) 
{
  l4_threadid_t ms, des, pager, preempter, from;
  l4_taskid_t tid;
  qword_t dummy;
  l4_ipcregs_t regs;  
  char d;
  int i;
  int pager_nr;

  ms = tid = l4_myself();
  pager_nr=tid.id.task-NEW_PAGER +1;
  print_hex (pager_nr, 32);
  print_string (" new pager\n\r");
  
  tid.id.task=tid.id.task+1;
  preempter = pager = L4_INVALID_ID;
  l4_thread_ex_regs (0, -1, -1, &preempter, &pager, &dummy, &dummy);

  if (pager_nr<LEVEL_COUNT) {
    l4_task_new (tid, 0, 0x222000, ms);
    for (i=0;i<MAX_FLUSH;i++) {
      l4_thread_ex_regs (i+3,
			 (qword_t)&flush_thread, (qword_t)(&flush_stack[((pager_nr-1)*MAX_FLUSH+i+1)*1024-1]), 
			 &preempter, &pager, &dummy, &dummy);

    }
  }  
   
  print_string("Create touchers...\n\r");
  for (i=0;i<TASK_COUNT;i++) {
    tid.id.task=NEW_TOUCHER+(pager_nr-1)*TASK_COUNT+i;
    l4_task_new(tid, 0, 0x222000, ms);   
  }
  print_string("Pager ");
  print_hex(pager_nr, 16);
  print_string (" is requesting page faults\n\r");

  while (1) {
    l4_alpha_ipc_wait (&from,
		       NULL,
		       &regs,
		       L4_IPC_NEVER);
    d+=memory[regs.val[0]];
    regs.val[0] = 
      regs.val[1] = (regs.val[0] & ~0x1fff) | (13 << 2) | 1;

    l4_alpha_ipc_send (from,
		       (void*)((qword_t)(NULL) | 0x02),
		       &regs,
		       L4_IPC_NEVER);
  }

  enter_kdebug ();
  while (1);
}

        


void timeout_thread (void)
{
  while(1) {
    l4_alpha_ipc_receive (l4_myself(),
			  NULL, NULL, L4_IPC_TIMEOUT (0, 0, 62500, 3, 0,0));
  }
  print_string ("Emergency Timeout\n");
  while(1);
  enter_kdebug ();
  halt();
}

void hinundher_thread (void)
{
  print_string("Hin- und her...\n\r");
   l4_alpha_ipc_receive (l4_myself(),
		    NULL, NULL, L4_IPC_TIMEOUT (0, 0, 62500, 3, 0,0));
  while (1) {}
    
}
  
void flush_thread (void)
{
  int i;
  static volatile int run = 0;

  // Set Myself to prio 0x81
  //print_string ("Before");  
  //l4_schedule (l4_myself(), L4_INVALID_ID, 0x81);
  //print_string ("After");
  l4_alpha_ipc_receive (l4_myself(),
		    NULL, NULL, L4_IPC_TIMEOUT (0, 0, 6250*5, 1, 0,0));

  run++;
  while(1) {
    l4_fpage_unmap((l4_fpage_t){fpage:(0x0400000 | (17 << 2)) | 1}, 0);
    //l4_fpage_unmap_easy(0x0400000, 5, 0, 0 );
    print_string("#");
#if 1
    l4_alpha_ipc_receive (l4_myself(),
			  NULL, NULL, L4_IPC_TIMEOUT (0, 0, 650*5, 1, 0,0));
#else
    for (i = 0; i < 500; i++)
	 l4_thread_switch (L4_NIL_ID);
#endif
    
  }
  enter_kdebug ();
  halt();
}


int main (void)
{ 
  l4_threadid_t ms, pager, preempter, from;
  l4_taskid_t tid, des;
  qword_t dummy;
  l4_ipcregs_t regs;  
  char d;
  int i,j;

  __asm__ ("lda $0, runsp; ldq $30, 0($0)\n");
  runsp += 0x2000;
  //print_hex(runsp, 64);

  ms = tid = l4_myself();
  print_hex (tid.id.task, 16);print_string (" ist task #\n\r");
  if (tid.id.task>= NEW_PAGER && tid.id.task <NEW_TOUCHER) {
	print_string ("Calling pager_init\n\r");
	root_pager ();
  } else
  if (tid.id.task >= NEW_TOUCHER) {
     print_string ("Calling toucher\n\r");
     root_toucher ();
  }
  print_string ("Create New Pager Task\n\r");

  // set rights...
  des = tid;
  for (j=0;j<LEVEL_COUNT;j++) {
    tid.id.task=NEW_PAGER+j;
    des.id.task=NEW_PAGER+j+1;
    print_string("*1");
    l4_grant_task (des, tid);
    for (i=0;i<TASK_COUNT;i++) {
      des.id.task = NEW_TOUCHER+(j*TASK_COUNT)+i;
      print_string("*2");
      l4_grant_task (des, tid);
    }
  }

  tid.id.task=NEW_PAGER;
  l4_task_new (tid, 0, 0x222000, ms);

  preempter = pager = L4_INVALID_ID;
  l4_thread_ex_regs (0, -1, -1, &preempter, &pager, &dummy, &dummy);
 
/*
  l4_thread_ex_regs (2, 
		     (qword_t)&timeout_thread, (qword_t)(&timeout_stack[1023]), 
		     &preempter, &pager, &dummy, &dummy);
*/
  for (i=0;i<MAX_FLUSH;i++) {
    l4_alpha_ipc_receive (l4_myself(),
			  NULL, NULL, L4_IPC_TIMEOUT (0, 0, 650, 1, 0,0));
    l4_thread_ex_regs (i+3,
		       (qword_t)&flush_thread, (qword_t)(&flush_stack[(i+1)*1024-1]), 
		       &preempter, &pager, &dummy, &dummy);
  }
  print_string ("S1 is requesting page faults\n\r");

  while (1) {
    l4_alpha_ipc_wait (&from,
		       NULL,
		       &regs,
		       L4_IPC_NEVER);
    //print_string ("Request sfrom ");print_hex(from.thread_id, 64);
    //print_string (" address : ");print_hex(regs.val[0],64);
    //print_string (".\n\r");

    d+=memory[regs.val[0]];
    
    regs.val[0] = 
     regs.val[1] = (regs.val[0] & ~0x1fff) | (13 << 2);

    l4_alpha_ipc_send (from,
		       (void*)((qword_t)(NULL) | 0x02),
		       &regs,
		       L4_IPC_NEVER);
    print_string (" s1 ");
  }
}






