#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>
#include <thread.h>

#define MAX_COUNT 4000

volatile char *memory  = (char *)0;
long int runsp = 0x800000;

qword_t Stack1[50000];

L4_INLINE void 
l4dbg_write_string (const char *str);

L4_INLINE void 
l4dbg_print_hex (long x, long bits);

inline void l4_grant_task (l4_threadid_t task, l4_taskid_t destination)
{
  l4_task_new (task, destination.thread_id, 0, L4_NIL_ID);
}

void printdec (int i)
{
        char str[32];
        int r;
        
        if (!i) {
                l4dbg_write_string ("0");
                return;
        }    
                
        str[31] = 0;
        str[30] = '0';
        for (r = 30; r && i; r--) {
                str[r] = '0' + (char)(i % 10);
                i = i / 10;
        }
        l4dbg_write_string (&(str[r+1]));
}

void TestThread(void* pParam) {
  //  l4dbg_debug();
  l4dbg_write_string("Hallo Test!\n\rIch  bin ");
  printdec ((int)pParam);
  l4dbg_write_string(" Prio: ");
  printdec(GetThreadPrio(GetCurrentThreadNr()));
  
  while(1) {
      printdec((int)pParam);
      l4dbg_write_string("Tick\n\r");
//      l4_thread_switch (L4_NIL_ID);
  }
      
}

main(void) {
  l4_threadid_t ms, from;
  l4_taskid_t tid;
  l4_ipcregs_t regs; 
  char d;
  qword_t i;

  __asm__ ("lda $0, runsp; ldq $30, 0($0)\n");

  l4dbg_print_hex(tid.id.task, 32);
  l4dbg_write_string(" is task id\n\r");
  for (i=0; i<20; i++) {
    CreateThread(i+5, 0, TestThread, &Stack1[2047+i*2048], (void*)i+5);
  }

  l4_alpha_ipc_wait (&from,
                     NULL,
                     &regs,
                     L4_IPC_NEVER);
  while (1) { 
    d+=memory[regs.val[0]];
    
    regs.val[0] = 
      regs.val[1] = (regs.val[0] & ~0x1fff) | (13 << 2);
    l4_alpha_ipc_reply_and_wait (from,
                                        (void*)((qword_t)(NULL) | 0x02),
                                        &regs,

                                        &from,
                                        NULL,
                                        &regs,

                                        L4_IPC_NEVER);
 
  }
}

