/* tests task delete
 *
 * Daniel Potts 990924
 *
 * This initial task starts up a chief task which then starts up several of
 * its own tasks. The chief task deletes a subtask, then the initial task
 * deletes the chief task. At this stage all tasks should have stopped.
 * This test is largely to ensure that the tasks have stopped executing.
 */


#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>
#include <thread.h>
#include <l4/kdebug.h>


qword_t _pager1_stack[1024];
qword_t _chief_stack[2048];

volatile char *memory = (char *)0;

inline void l4_grant_task (l4_threadid_t task, l4_taskid_t destination)
{
  l4_task_new (task, destination.thread_id, 0, 0, L4_NIL_ID);
}

#define CHIEF_TASK 10
#define SUBTASK_A  11
#define SUBTASK_B  12
#define SUBTASK_C  13

#define SUBTASK_C_SUB_A 14	// for more extensive testing of delete

main(void) {
    l4_taskid_t chief_tid, subtaskA_tid, subtaskB_tid, subtaskC_tid;
    l4_taskid_t tmptid;
    l4_threadid_t pager;

    print_string("Main Started\n\r");

    /* start up a pager so that we dont have to be the pager */
    pager = l4_myself();
    pager.id.lthread = 10;
    CreateThread(10, 0, pager1, &_pager1_stack[1023], (void*)10);

    

    /* give the chief task permission to create four other tasks */

    chief_tid.id.chief = l4_myself().id.task;
    chief_tid.id.task = CHIEF_TASK;

    for(tmptid.id.task = SUBTASK_A; tmptid.id.task <= SUBTASK_C_SUB_A;
	tmptid.id.task++)
	l4_grant_task(tmptid, chief_tid);

    /* now we can create the chief task */
    print_string("Main: Creating chief task\n\r");
    l4_task_new (chief_tid, 0xf0, &_chief_stack[2047], chief_main, pager);

    print_string("Main: chief task created\n\r");

    /* wait for ipc, then kill chief task */

    // FIXME

}


void pager1(void) {
    l4_threadid_t ms, pager, from,  oid;
    l4_ipcregs_t regs;  
    l4_msgdope_t result;
    qword_t old;
    char d;

    ms = l4_myself();
    print_string("Pager1: G'day I'm Pager1 ");
    print_hex(l4_myself().thread_id,64);
    print_string("\n\r");

    l4_alpha_ipc_wait (&from,
                       NULL,
                       &regs,
                       L4_IPC_NEVER, &result);
  
  while (1) {
#if 0
      print_string("Pager1: Received req, dope =");
      print_hex(result.msgdope,64);
      print_string("Pager1: From.");
      print_hex(from.thread_id,64);
#endif
      if ((regs.val[0] == old) && (oid.id.task == from.id.task)) {
          print_string ("P1:Got addr 2 times\n\rAddr "); print_hex (old, 64); 
          print_string (";  IP = "); print_hex (regs.val[1], 64);
          print_string ("\n\rP1:Faulting Thread is ");
          print_hex (oid.thread_id, 64); print_string ("\n\r");
      }
      old = regs.val[0]; oid = from;
      d +=memory[regs.val[0]];
      regs.val[0] = 
          regs.val[1] = ((regs.val[0]) & ~PAGEMASK) | (13 << 2) | 1;

      l4_alpha_ipc_reply_and_wait (from,
                                 (void*)((qword_t)(NULL) | 0x02),
                                 &regs,
                                 &from,
                                 NULL,
                                 &regs,
                                 L4_IPC_NEVER, &result);
    if (L4_IPC_IS_ERROR(result)) {
        print_string ("P1: Cannot send, why ?\n\r");
        print_hex (result.msgdope, 64);
    }

  }

  print_string("P1: I SHOULDNT GET HERE\n\r");

  enter_kdebug ();
  while (1);

}
