/*  Gauntlet/kernel/Brutus/brutus.h
 *  Created by Adam Wiggins: 22/06/1999
 *  Last Modified by Adam Wiggins: 18/09/1999
 *  Brutus Platform Specific defines and macros
 */

#ifndef BRUTUS_H 
#define BRUTUS_H

#include <sa1100.h>
#include <types.h>

/**********
* Externs *
**********/

#ifdef LANGUAGE_C

extern byte_t init_addr[];
extern byte_t kcda_pbase[];

#endif LANGUAGE_C

/***********************
* Memory Configuration *
***********************/

/* Size of SA1100 DRAM */
#define MEMORY_SIZE (DRAM_BANK_NUMBER * DRAM_BANK_SIZE)

/* 4 Banks of DRAM */
#define DRAM_BANK_NUMBER 4

/* 4 MB Per DRAM Bank */
#define DRAM_BANK_SIZE (4 << 20)

/***************************
* Initialisation Addresses *
***************************/

/* Physical/Virtual Address of kernel init segment */
#define INIT_BASE (init_addr)

/* Physical/Virtual Address of init stack */
#define INIT_STACK (INIT_BASE + 0x100000)

/*********************
* Physical Addresses *
*********************/

/* Base of Kernel Code/Data Area */
#define KCDA_PBASE ((word_t)kcda_pbase)

/********************
* Virtual Addresses *
********************/


#endif BRUTUS_H
