/*  Gauntlet/kernel/Brutus/init.c
 *  Created by Adam Wiggins: 22/06/1999
 *  Last Modified by Adam Wiggins: 18/09/1999
 *  Brutus Platform Specific Gauntlet intialisation code
 */ 

#include <init.h>

/* memSize(): Calculates the size of platforms memory.
 * Pre:       None.
 * Post:      Returns number of bytes of memory on platform. */
word_t 
memSize(void)
{
  return MEMORY_SIZE;
} /* memSize() */

/* mapContRAM(): Adds mappings for the Platform RAM into the Caching Kernel
 *               Pagetable (1MB sections cached/buffered).
 * Pre:          Caching Page Directory Initialised.
 * Post:         Brutus DRAM frames (4 x 4MB) mapped in. */
void 
mapContRAM(void)
{
  int i, j;
  fld_section_t *section;

  /* Each DRAM Bank */
  for(i = 0; i < DRAM_BANK_NUMBER; i++) 
    /* Each 1MB in Bank */
    for(j = 0; j < vaddrToFLD(DRAM_BANK_SIZE); j++) {
      section = (fld_section_t *)cache_page_dir_p + vaddrToFLD(RAM_VBASE) + 
        (i * vaddrToFLD(DRAM_BANK_SIZE)) + j;
      section->type = FLD_SECTION;               /* 1st Level Section Entry */
      section->ap = AP_NOACCESS;                 /* Kernel Access only */
      section->sba = 
        paddrToSBA(DRAM0_PBASE) + (i * 128) + j; /* Address of 1MB Frame */
    }
} /* mapContRAM() */
