/*  Gauntlet/kernel/PS7110/debug_serial.c
 *  Created by Adam Wiggins: 18/09/1999
 *  Last Modified by Adam Wiggins: 18/09/1999
 *  PS7110 CPU Specific Serial code
 */

#include <debug.h>

/* putc: Output a character down the UART serial line.
 * Pre:  Serial port is initialised.
 * Post: Character sent. 
 * Status: Not done for PS7110 yet. */
void
putc(char chr)
{
  volatile int tmp;

/* Wait till the Transmit FIFO has a free slot */
  do 
    //tmp = *(int *)(DSERIAL_VBASE + DSERIAL_UTSR1);
  while (!(tmp & UTSR1_TNF));
/* Add the character to the Transmit FIFO */
    //*(int *)(DSERIAL_VBASE + DSERIAL_UTDR) = (int)chr;
} /* putc */

/* getc: Get a character from the UART serial line.
 * Pre:  Serial port is initialised.
 * Post: Character received.
 * Status: Not done for PS7110 yet. */
char
getc(void)
{
  volatile int tmp;

/* Wait till the receive FIFO has something in it */
  do
    //tmp = *(int *)(DSERIAL_VBASE + DSERIAL_UTSR1);
  while (!(tmp & UTSR1_RNE));
/* Read a character from the Receive FIFO */
  return; // (char)(*(int *)(DSERIAL_VBASE + DSERIAL_UTDR));
}
