/*  Gauntlet/kernel/PS7110/init.c
 *  Created by Adam Wiggins: 18/09/1999
 *  Last Modified by Adam Wiggins: 18/09/1999
 *  PS7110 CPU Specific code for Gauntlet intialisation
 */ 

#include <init.h>

/* initOSTimers(): Initialises the OS timer registers and unmaskes alarm 
 *                 interrupts.
 * Pre:            ?
 * Post:           ? 
 * Status:         Not done.
 * Priority:       Not needed till scheduling implimented. */
void 
initOSTimers(void)
{
/* Initialise registers */
  /* FIXME! */
/* Unmask Alarm interrupts */
  /* FIXME! */
} /* initOSTimers() */

/* mapPlatformIO(): Adds mappings for the Platform I/O registers into the 
 *                  Caching Kernel Pagetable (4KB small pages no caching).
 * Pre:             Caching Page Directory initialised.
 * Post:            SA-1100 I/O registers (Interrupt Controler, OS Timer) 
 *                  mappings added to Caching Page Direcotry.
 * Status:          Not done. */
void 
mapPlatformIO(void)
{
  sld_t *page_table = (sld_t *)(KCDA_PBASE + KCDA_DATA + 0x800); // Maybe move
  sld_smallpage_t *small_page;
  fld_coarse_t *coarse;
  int i;

/* Add 1st Level Entry */ 
  coarse = (fld_coarse_t *)cache_page_dir_p + vaddrToFLD(INTCTRL_VBASE);
  coarse->type= FLD_COARSE;
  coarse->cptba = paddrToCPTBA(page_table);
/* Zero out 2nd Level Array */
  for(i = 0; i < CSLD_MAX; i++)
    page_table[i].init = 0;
// FIX Up the rest for PS7110
} /* mapPlatformIO() */

/* mapSigma0(): Builds Sigma0's pagetable (currently using cache_page_dir) 
 * Pre:         Caching Page Directory initialised (until FASS done).
 * Post:        Sigma0 has one-one mapping of valid physical regions less
 *              area's reserved for the kernel.
 * Status:      Not done for PS7110. */
void 
mapSigma0(void)
{
  int i;
  fld_coarse_t *page;
  fld_section_t *section;
  sld_smallpage_t *small_page;
  sld_t *page_table_p, *page_table;

// Fill in for PS7110
} /* mapSigma0() */
