/*  Gauntlet/kernel/Photon/photon.h
 *  Created by Adam Wiggins: 05/08/1999
 *  Last Modified by Adam Wiggins: 05/08/1999
 *  Photon specific defines and macros
 */

#ifndef PHOTON_H 
#define PHOTON_H

#include <sa1100.h>

/***********************
* Memory Configuration *
***********************/

/* Size of Photon DRAM */
#define MEMORY_SIZE (DRAM_BANK_NUMBER * DRAM_BANK_SIZE)

/* 1 Banks of DRAM */
#define DRAM_BANK_NUMBER 1

/* 16 MB Per DRAM Bank */
#define DRAM_BANK_SIZE (16 << 22)

/***************************
* Initialisation Addresses *
***************************/

/* Physical/Virtual Address of kernel init segment */
#define INIT_BASE (DRAM1_PBASE + 0x100000)

/* Physical/Virtual Address of init stack */
#define INIT_STACK (INIT_BASE + 0x10000)

/*********************
* Physical Addresses *
*********************/

/* Base of Kernel Code/Data Area */
#define KCDA_PBASE DRAM0_PBASE

/********************
* Virtual Addresses *
********************/


#endif PHOTON_H
