/*  Gauntlet/kernel/Psion5/psion5.h
 *  Created by Adam Wiggins: 18/09/1999
 *  Last Modified by Adam Wiggins: 18/09/1999
 *  Psion 5 Platform Specific defines and macros
 */

#ifndef PSION5_H 
#define PSION5_H

#include <ps7110.h>
#include <types.h>

/**********
* Externs *
**********/

#ifdef LANGUAGE_C

extern byte_t init_addr[];
extern byte_t kcda_pbase[];

#endif LANGUAGE_C

/***********************
* Memory Configuration *
***********************/

/* Size of PS7110 DRAM */
#define MEMORY_SIZE (DRAM_BANK_NUMBER * DRAM_BANK_SIZE)

/* 16 Banks of DRAM */
#define DRAM_BANK_NUMBER 16

/* 512 KB Per DRAM Bank */
#define DRAM_BANK_SIZE (512 << 10)

/***************************
* Initialisation Addresses *
***************************/

/* Physical/Virtual Address of kernel init segment */
#define INIT_BASE (init_addr)

/* Physical/Virtual Address of init stack */
#define INIT_STACK (INIT_BASE + 0x100000)

/*********************
* Physical Addresses *
*********************/

/* Base of Kernel Code/Data Area */
#define KCDA_PBASE ((word_t)kcda_pbase)

/********************
* Virtual Addresses *
********************/


#endif PSION5_H
