/*  Gauntlet/kernel/SA1100/debug.c
 *  Created by Adam Wiggins: 14/08/1999
 *  Last Modified by Adam Wiggins: 18/09/1999
 *  SA-1100 CPU Specific code for debugger
 */ 

#include <init.h>

/* mapKDebug(): Add kernel debugger mappings to page_dir. 
 * Pre:         Caching Page Directory initialised and contains mappings for 
 *              Interrupt Controler Registers.
 * Post:        Debugging I/O mappings added to page_dir. 
 * Status:      Done. */
void 
mapKDebug(void)
{
  sld_t *page_table;
  sld_smallpage_t *small_page;
  fld_coarse_t *coarse;

  /* Get 2nd Level Page Table */
  coarse = (fld_coarse_t *)cache_page_dir_p + vaddrToFLD(INTCTRL_VBASE);
  page_table = (sld_t *)cptbaToPaddr(coarse->cptba);
  /* Map in UART Serial Port Registers */
  small_page = (sld_smallpage_t *)page_table + vaddrToCSLD(DSERIAL_VBASE);
  *(small_page) = page_table[vaddrToCSLD(INTCTRL_VBASE)].small;
  small_page->spba = paddrToSPBA(DSERIAL_PBASE);
  /* Map in GPIO Registers */
  small_page = (sld_smallpage_t *)page_table + vaddrToCSLD(GPIO_VBASE);
  *(small_page) = page_table[vaddrToCSLD(INTCTRL_VBASE)].small;
  small_page->spba = paddrToSPBA(GPIO_PBASE);
} /* initKDebug() */
