/*  Gauntlet/kernel/SA1100/debug_asm.S
 *  Created by Adam Wiggins: 04/10/1999
 *  Last Modified by Adam Wiggins: 04/10/1999
 *  SA1100 CPU Specific asm physical addresses serial code
 */

#include <asm.h>
#include <platform.h>

/* pputc: Output a character down the Uart serial line.
 * Pre:   Serial port is initialised, r0 contains character.
 * Post:  Stratch[r1, r2], Character sent. */
INIT(pputc)
	ldr	r1, 2f
/* Wait till the Transmit FIFO has a free slot */
1:
	ldr	r2, [r1, #DSERIAL_UTSR1]
	tst	r2, #UTSR1_TNF
	beq	1b
/* Add the character to the Transmit FIFO */
	str	r0, [r1, #DSERIAL_UTDR]
/* Return */
	mov	pc, lr
/* end pputc */
2:	.word	DSERIAL_PBASE

/* pgetc: Get a character from the Uart serial line.
 * Pre:   Serial port is initialised.
 * Post:  Stratch[r1, r2], Character received and in r0. */
INIT(pgetc)
	ldr	r1, 2b
/* Wait till the receive FIFO has something in it */
1:
	ldr	r2, [r1, #DSERIAL_UTSR1]
	tst	r2, #UTSR1_RNE
	beq	1b
/* Read a character from Receive FIFO */
	ldr	r0, [r1, #DSERIAL_UTDR]
/* Return */
	mov	pc, lr
/* end pgetc */
