/*  Gauntlet/kernel/SA1100/init.c
 *  Created by Adam Wiggins: 22/06/1999
 *  Last Modified by Adam Wiggins: 18/09/1999
 *  SA-1100 CPU Specific code for Gauntlet intialisation
 */ 

#include <init.h>

/* initOSTimers(): Initialises the OS timer registers and unmaskes alarm 
 *                 interrupts.
 * Pre:            ?
 * Post:           ? 
 * Status:         Not done.
 * Priority:       Not needed till scheduling implimented. */
void 
initOSTimers(void)
{
/* Initialise registers */
  /* FIXME! */
/* Unmask Alarm interrupts */
  /* FIXME! */
} /* initOSTimers() */

/* mapPlatformIO(): Adds mappings for the Platform I/O registers into the 
 *                  Caching Kernel Pagetable (4KB small pages no caching).
 * Pre:             Caching Page Directory initialised.
 * Post:            SA-1100 I/O registers (Interrupt Controler, OS Timer) 
 *                  mappings added to Caching Page Direcotry. */
void 
mapPlatformIO(void)
{
  sld_t *page_table = (sld_t *)(KCDA_PBASE + KCDA_DATA + 0x800); // Maybe move
  sld_smallpage_t *small_page;
  fld_coarse_t *coarse;
  int i;

/* Add 1st Level Entry */ 
  coarse = (fld_coarse_t *)cache_page_dir_p + vaddrToFLD(INTCTRL_VBASE);
  coarse->type= FLD_COARSE;
  coarse->cptba = paddrToCPTBA(page_table);
/* Zero out 2nd Level Array */
  for(i = 0; i < CSLD_MAX; i++)
    page_table[i].init = 0;
/* Map in Interrupts Controler Registers */
  small_page = (sld_smallpage_t *)page_table + vaddrToCSLD(INTCTRL_VBASE);
  small_page->type = SLD_SMALL;
  small_page->ap0 = AP_NOACCESS;
  small_page->ap1 = AP_NOACCESS;
  small_page->ap2 = AP_NOACCESS;
  small_page->ap3 = AP_NOACCESS;
  small_page->spba = paddrToSPBA(INTCTRL_PBASE);
/* Map in OS Timer Registers */
  small_page = (sld_smallpage_t *)page_table + vaddrToCSLD(OSTIMER_VBASE);
  *(small_page) = page_table[vaddrToCSLD(INTCTRL_VBASE)].small;
  small_page->spba = paddrToSPBA(OSTIMER_PBASE); 
} /* mapPlatformIO() */

/* mapSigma0(): Builds Sigma0's pagetable (currently using cache_page_dir) 
 * Pre:         Caching Page Directory initialised (until FASS done).
 * Post:        Sigma0 has one-one mapping of valid physical regions less
 *              area's reserved for the kernel. */
void 
mapSigma0(void)
{
  int i;
  fld_coarse_t *page;
  fld_section_t *section;
  sld_smallpage_t *small_page;
  sld_t *page_table_p, *page_table;

/* Map in Static RAM Banks (less NULL page), 0x00000000 - 0x1FFFFFFF */
  /* Allocate 2nd Level Array for NULL page */
  page_table = (sld_t *)kernel_data->freelist_1kb;
  kernel_data->freelist_1kb = kernel_data->freelist_1kb->next;
  page_table_p = (sld_t *)vaddrToPaddr0(page_table);
  /* Add 1st Level Entry covering NULL page */
  page = (fld_coarse_t *)cache_page_dir;
  page->type = FLD_COARSE;
  page->domain = USER01_DOMAIN;
  page->cptba = paddrToCPTBA(page_table_p);
  /* Zero out 2nd Level Array */
  for(i = 0; i < CSLD_MAX; i++)
    page_table[i].init = 0;
  /* Add 2nd Level Entries (NULL left out for SA-1100) */
  small_page = (sld_smallpage_t *)page_table;
  for(i = 1; i < CSLD_MAX; i++) {
    small_page[i].type = SLD_SMALL;
    small_page[i].buf = TRUE;
    small_page[i].cache = TRUE;
    small_page[i].ap0 = AP_ALLACCESS;
    small_page[i].ap1 = AP_ALLACCESS;
    small_page[i].ap2 = AP_ALLACCESS;
    small_page[i].ap3 = AP_ALLACCESS;
    small_page[i].spba = i;
  }
  /* Map in remainning sections */
  section = (fld_section_t *)cache_page_dir;
  for(i = 1; i < 512; i++) {
    section[i].type = FLD_SECTION;
    section[i].buf = TRUE;
    section[i].cache = TRUE;
    section[i].domain = USER01_DOMAIN;
    section[i].ap = AP_ALLACCESS;
    section[i].sba = i;
  }
/* Map in PCMCIA Space, 0x20000000 - 0x3FFFFFFF */
  //FIXME make Memory regions buf/cachable.
  section = (fld_section_t *)cache_page_dir + 512;
  for(i = 0; i < 512; i++, section++) {
    section->type = FLD_SECTION;
    section->domain = USER01_DOMAIN;
    section->ap = AP_ALLACCESS;
    section->sba = i + 512;
  }
/* Map in I/O Registers (less kernel OSTIMER/INTCTRL), 
   0x80000000 - 0xBFFFFFFF */
  //FIXME! Remove OSTIMER and INTCTRL from mappings!
  section = (fld_section_t *)cache_page_dir + 2048;
  for(i = 0; i < 1024; i++, section++) {
    section->type = FLD_SECTION;
    section->domain = USER01_DOMAIN;
    section->ap = AP_ALLACCESS;
    section->sba = i + 2048;
  }
/* Map in DRAM Banks (less kernel regions, First 2MB currently),
   0xC0000000 - 0xDFFFFFFF */
  section = (fld_section_t *)cache_page_dir + 3074;
  for(i = 2; i < 512; i++, section++) {
    section->type = FLD_SECTION;
    section->buf = TRUE;
    section->cache = TRUE;
    section->domain = USER01_DOMAIN;
    section->ap = AP_ALLACCESS;
    section->sba = i + 3072;
  }
  /* Map in Zero Bank (Fast DCache cleanning), 0xE0000000 - 0xE7FFFFFF */
  section = (fld_section_t *)cache_page_dir + 3584;
  for(i = 0; i < 128; i++, section++) {
    section->type = FLD_SECTION;
    section->buf = TRUE;
    section->cache = TRUE;
    section->domain = USER01_DOMAIN;
    section->ap = AP_READACCESS;
    section->sba = i + 3584;
  }
} /* mapSigma0() */
