/*  Gauntlet/kernel/SA1100/sa1100.h
 *  Created by Adam Wiggins: 22/06/1999
 *  Last Modified by Adam Wiggins: 04/10/1999
 *  SA-1100 CPU Specific defines and macros
 */

#ifndef SA1100_H
#define SA1100_H

#include <types.h>

/***************************
* Initialisation Constants *
***************************/

#define CNTRL_FLAGS (CONTR_M |   /* Enable MMU */                    \
                     CONTR_A |   /* Enable Alignment Faults */       \
                     /*CONTR_C |*/   /* Enable Data Cache */             \
                     /*CONTR_W |*/   /* Enable Write Buffer */           \
                     CONTR_S |   /* Set Restricted Permition Mode */ \
                     CONTR_I |   /* Enable Instruction Cache */      \
                     CONTR_X)    /* Relocate Exception Vector */

/************************************
* Kernel Cachablility/Bufferability *
************************************/

#define KERNEL_CACHABLE   TRUE  /* This assigns all kernel data to the */
#define KERNEL_BUFFERABLE FALSE /* Mini-Data cache on the SA-1100      */

/*********************************
* I/O Register Virtual Addresses *
*********************************/

// Move these to I/O vbase linker symbols + offset

/* Interrupt Controler Registesr */
#define INTCTRL_VBASE 0xF8000000

/* OS Timer Registers */
#define OSTIMER_VBASE 0xF8010000

/********************************************
* I/O Register Physical Locations + Defines * 
********************************************/

/* Memory Registers */

#define DRAM0_PBASE 0xc0000000
#define DRAM1_PBASE 0xc8000000
#define DRAM2_PBASE 0xd0000000
#define DRAM3_PBASE 0xd8000000

/* OS Timer Registers */

#define OSTIMER_PBASE  0x90000000
#define OSTIMER_0      0x0
#define OSTIMER_1      0x4
#define OSTIMER_2      0x8
#define OSTIMER_3      0xC
#define OSTIMER_COUNT  0x10
#define OSTIMER_STATUS 0x14
#define OSTIMER_WATCH  0x18
#define OSTIEMR_INTEN  0x1C

/* Interrupt Controler Registers */

#define INTCTRL_PBASE 0x90050000
#define INTCTRL_ICIP  0x0
#define INTCTRL_ICMR  0x4
#define INTCTRL_ICLR  0x8
#define INTCTRL_ICCR  0xC
#define INTCTRL_ICFP  0x10
#define INTCTRL_ICPR  0x20

/*********
* Macros *
*********/

/* CP15 Flush Read Buffers */
#define Flush_ReadBuffers \
	mcr	p15, 0, r0, c9, c0, 0

/* CP15 Flush Read Buffer 0 */
#define Flush_ReadBuffer0 \
	mcr	p15, 0, r0, c9, c0, 1

/* CP15 Flush Read Buffer 1 */
#define Flush_ReadBuffer1 \
	mcr	p15, 0, r0, c9, c1, 1

/* CP15 Flush Read Buffer 2 */
#define Flush_ReadBuffer2 \
	mcr	p15, 0, r0, c9, c2, 1

/* CP15 Flush Read Buffer 3 */
#define Flush_ReadBuffer3 \
	mcr	p15, 0, r0, c9, c3, 1

/* CP15 Load Buffer 0 single word, virtual address in ARM register */
#define Load_ReadBufSng0(reg) \
	mcr	p15, 0, reg, c9, c0, 2

/* CP15 Load Buffer 0 quad word, virtual address in ARM register */
#define Load_ReadBufQud0(reg) \
	mcr	p15, 0, reg, c9, c4, 2

/* CP15 Load Buffer 0 eight word, virtual address in ARM register */
#define Load_ReadBufOct0(reg) \
	mcr	p15, 0, reg, c9, c8, 2

/* CP15 Load Buffer 1 single word, virtual address in ARM register */
#define Load_ReadBufSng1(reg) \
	mcr	p15, 0, reg, c9, c1, 2

/* CP15 Load Buffer 1 quad word, virtual address in ARM register */
#define Load_ReadBufQud1(reg) \
	mcr	p15, 0, reg, c9, c5, 2

/* CP15 Load Buffer 1 eight word, virtual address in ARM register */
#define Load_ReadBufOct1(reg) \
	mcr	p15, 0, reg, c9, c9, 2

/* CP15 Load Buffer 2 single word, virtual address in ARM register */
#define Load_ReadBufSng2(reg) \
	mcr	p15, 0, reg, c9, c2, 2

/* CP15 Load Buffer 2 quad word, virtual address in ARM register */
#define Load_ReadBufQud2(reg) \
	mcr	p15, 0, reg, c9, c6, 2

/* CP15 Load Buffer 2 eight word, virtual address in ARM register */
#define Load_ReadBufOct2(reg) \
	mcr	p15, 0, reg, c9, c10, 2

/* CP15 Load Buffer 3 single word, virtual address in ARM register */
#define Load_ReadBufSng3(reg) \
	mcr	p15, 0, reg, c9, c3, 2

/* CP15 Load Buffer 3 quad word, virtual address in ARM register */
#define Load_ReadBufQud3(reg) \
	mcr	p15, 0, reg, c9, c7, 2

/* CP15 Load Buffer 3 eight word, virtual address in ARM register */
#define Load_ReadBufOct3(reg) \
	mcr	p15, 0, reg, c9, 11, 2

/* CP15 Disable User Read Buffer MCR access */
#define Disable_ReadBufUsr \
	mcr	p15, 0, r0, c9, c0, 4

/* CP15 Enable User Read Buffer MCR access */
#define Enalbe_ReadBufUsr \
	mcr	p15, 0, r0, c9, c0, 5

/* Move CP15 PID register to ARM register */
#define ReadCP15_PID(reg) \
	mrc	p15, 0, reg, c13, c0, 0

/* Move ARM register to CP15 PID register */
#define WriteCP15_PID(reg) \
	mcr	p15, 0, reg, c13, c0, 0

/* FIXME! Add the break points CP15 macros for SA1100 */

/* FIXME! Add the rest of Test/Clock/Idle CP15 Control register */

/* CP15 Enable Clock Switching */
#define Enable_ClockSW \
	mcr	p15, 0, r0, c15, c1, 2

/* CP15 Disable Clock Switching */
#define Disable_ClockSW \
	mcr	p15, 0, r0, c15, c2, 2

/* CP15 Wait for interupt */
#define Wait_For_Int \
	mcr	p15, 0, r0, c15, c8, 2


#endif SA1100_H
