/*  Gauntlet/kernel/SA1100/sa1100_debug.h
 *  Created by Adam Wiggins: 14/08/1999
 *  Last Modified by Adam Wiggins: 18/09/1999
 *  SA-1100 CPU Specific defines and macros for debugger
 */

#ifndef SA1100_DEBUG_H
#define SA1100_DEBUG_H

/*********************************
* I/O Register Virtual Addresses *
*********************************/

// As with sa1100.h move to I/O vbase linker symbol plus offset

/* UART Serial Port Register */
#define DSERIAL_VBASE 0xF8020000

/* GPIO Registers */
#define GPIO_VBASE 0xF8030000

/********************************************
* I/O Register Physical Locations + Defines * 
********************************************/

/* UART Serial Port Registers */

#define DSERIAL_UTCR0 0x0
#define DSERIAL_UTCR1 0x4
#define DSERIAL_UTCR2 0x8
#define DSERIAL_UTCR3 0xC
#define DSERIAL_UTDR  0x14
#define DSERIAL_UTSR0 0x1C
#define DSERIAL_UTSR1 0x20

#define UTSR0_TFS 0x01
#define UTSR0_RFS 0x02
#define UTSR0_RID 0x04
#define UTSR0_RBB 0x08
#define UTSR0_REB 0x10
#define UTSR0_EIF 0x20

#define UTSR1_TBY 0x01
#define UTSR1_RNE 0x02
#define UTSR1_TNF 0x04
#define UTSR1_PRE 0x08
#define UTSR1_FRE 0x10
#define UTSR1_ROR 0x20

/* GPIO Registers */

#define GPIO_PBASE 0x90040000
#define GPIO_GPLR  0x0
#define GPIO_GPDR  0x4
#define GPIO_GPSR  0x8
#define GPIO_GPCR  0xC
#define GPIO_GRER  0x10
#define GPIO_GFER  0x14
#define GPIO_GEDR  0x18
#define GPIO_GAFR  0x1C

#define GPIO00 0x00000001
#define GPIO01 0x00000002
#define GPIO02 0x00000004
#define GPIO03 0x00000008
#define GPIO04 0x00000010
#define GPIO05 0x00000020
#define GPIO06 0x00000040
#define GPIO07 0x00000080
#define GPIO08 0x00000100
#define GPIO09 0x00000200
#define GPIO10 0x00000400
#define GPIO11 0x00000800
#define GPIO12 0x00001000
#define GPIO13 0x00002000
#define GPIO14 0x00004000
#define GPIO15 0x00008000
#define GPIO16 0x00010000
#define GPIO17 0x00020000
#define GPIO18 0x00040000
#define GPIO19 0x00080000
#define GPIO20 0x00100000
#define GPIO21 0x00200000
#define GPIO22 0x00400000
#define GPIO23 0x00800000
#define GPIO24 0x01000000
#define GPIO25 0x02000000
#define GPIO26 0x04000000
#define GPIO27 0x08000000

/*********
* Macros *
*********/


#endif SA1100_DEBUG_H
