B
/*  Gauntlet/kernel/asm.h
 *  Created by Adam Wiggins: 30/06/1999
 *  Last Modified by Adam Wiggins: 21/10/1999 
 *  Assembler macros
 */

#ifndef ASM_H
#define ASM_H

/* Global Label */
#define GLOBAL(x)  \
	.global x ;\
x:

/* Kernel Procedure */
#define PROC(x)   \
	.text    ;\
	.globl x ;\
	.align   ;\
x:

/* Initialisation Procedure */
#define INIT(x)              \
	.section .init,"xa" ;\
	.globl x            ;\
	.align              ;\
x:

/* Exception Procedure on Vector Table Page (page at 0x0 virtual address) */
#define EXCP(x)              \
        .section .excp,"xa" ;\
        .globl x            ;\
	.align              ;\
x:

/* Exception Vector Table (used to force linking order) */
#define VECT(x)              \
	.section .vect,"xa" ;\
	.globl x            ;\
	.align              ;\
x:

/* FIQ handler (used to force linking order) */ 
#define FIQV(x)              \
	.section .fiqv,"xa" ;\
	.globl x            ;\
	.align              ;\
x:


#endif ASM_H
