/*  Gauntlet/kernel/debug.h
 *  Created by Adam Wiggins: 14/09/1999
 *  Last Modified by Adam Wiggins: 27/09/1999 
 *  Generic debug defines and macros
 */

#ifndef DEBUG_H
#define DEBUG_H

#include <arm.h>
#include <mmu.h>
#include <tcb.h>
#include <types.h>
#include <kernel.h>
#include <platform.h>

/**********
* Externs *
**********/

extern kernel_data_t kernel_data[];
extern task_table_t task_table[];

/**********************
* Function Prototypes *
**********************/

int gethex(char *) __attribute__ ((section (".init")));
int puts(char *) __attribute__ ((section (".init")));
int gets(char *) __attribute__ ((section (".init")));
int char2hex(char) __attribute__ ((section (".init")));
void print_hex(word_t val) __attribute__ ((section (".init")));
void print_dec(word_t val) __attribute__ ((section (".init")));
int printf(char* format, ...) __attribute__ ((section (".init")));
void dumpPT(fld_t *page_dir) __attribute__ ((section (".init")));
void dumpTT(void) __attribute__ ((section (".init")));
void dumpKD(void) __attribute__ ((section (".init")));
void dumpTCB(tcb_t *tcb) __attribute__ ((section (".init")));
char getc(void) __attribute__ ((section (".init")));
void putc(char) __attribute__ ((section (".init")));


#endif DEBUG_H
