/*  Gauntlet/kernel/dispatch.S
 *  Create by Adam Wiggins: 10/10/1999
 *  Last Modified by Adam Wiggins: 06/11/1999
 *  Generic ARM code for thread dispatching
 */

#include <arm.h>
#include <asm.h>
#include <tcb.h>
#include <panic.h>
#include <macros.h>

/* dispatch_next: Find next ready thread and dispatch it.
 * Pre:           Current thread's state is stacked,
 *                r13 = Kernel Misc Data Pointer,
 *                r7 = Current thread's control block.
 * Post:          r1 = Next ready thread's control block and dispatched ELSE,
 *                Idle thread dispatched.
 * Registers      r11 = Highest ready priority offset (for kpd),
 *                r12 = Temp 0,
 *                r14 = Temp 1.
 * Status:        Untested.
 * Priority:      Important. */
EXCP(dispatch_next)
	ldr	r11, [r13, #K_HIGHEST_PRIO]	@ Load the priority offset
/* S */ cmn	r11, #NEG_INVALID		@ Test for no ready threads
	beq	dispatch_idle			@ no thread ready, dispatch_idle
	ldr	r1, [r13, r11]			@ Load head of ready queue
1:						@ Check if head is ready
/* S */ ldr	r14, [r1, #T_FINE_STATE]	@ Load heads fine state
/* R */	ldr	r12, [r1, #T_READY_NEXT]	@ Load next ready thread
	teq	r14, #FS_READY			@ Test if thread ready to run
	beq	4f				@ if not ready, go on
/* Remove busy thread from ready queue */	
	cmp	r12, r1				@ Check if last thread in queue
	beq	2f				@ If not, go on
	ldr	r14, [r1, #T_READY_PREV]	@ Load prev ready thread	
	str	r1, [r1, #T_READY_NEXT]		@ Point thread to itself
	str	r1, [r1, #T_READY_PREV]		@ Point thread to itself
	str	r14, [r12, #T_READY_PREV]	@ Point nexts prev to prev
	str	r12, [r14, #T_READY_NEXT]	@ Point prevs next to next
	mov	r1, r12				@ Update head
	b	1b				@ Check head again
2:						@ Remove last thread of queue
	str	r1, [r1, #T_READY_NEXT]		@ Point thread to itself
	str	r1, [r1, #T_READY_PREV]		@ Point thread to itself
	mov	r1, #NULL			@ Move NULL into head
	str	r1, [r13, r11]			@ Store NULL head to ready queue
3:						@ Check next priority down
	sub	r11, r11, #4			@ Update ready priority offset
	cmp	r11, #K_READY_QUEUE		@ Ready queues exhausted?
	bge	dispatch_idle			@ If so, dispatch_idle
	ldr	r1, [r13, r11]			@ Load head of ready queue
	cmp	r1, #NULL			@ Check if queue empty
	beq	3b				@ If not, go on
	str	r11, [r13, #K_HIGHEST_PRIO]	@ Store new priority offset
	b	1b				@ check head again
4:						@ Update ready queue
	str	r12, [r13, r11]			@ Update ready queue head
/* Flow into dispatch_thread */
/* end dispatch_next */

/* dispatch_thread: Dispatch to specified thread.
 * Pre:             r1 = Destination Thread's Control Block,
 *                  r7 = Current Thread's Control Block,
 *                  r13 = Kenel Misc Data Pointer.
 * Post:            Switch to destination thread's context and jump to its 
 *                  return procedure.
 * Registers:       r0 = Destination Thread's Kernel Stack Pointer,
 *                  r14 = Temp.
 * Status:          On the way, untested so far. */
EXCP(dispatch_thread)
	DISPATCH_THREAD(r1, r7, r14)
/* end dispatch_thread */

/* dispatch_idle: Dispatch the idle thread, wait for interrupt.
 * Pre:           ?
 * Post:          ?
 * Status:        Not done yet.
 * Priority:      Not certian, probably high. */
EXCP(dispatch_idle)
	// FILL ME - Put CPU into idle or infinite loop (ie wait for interrupt)
	mov	r0, #UNIMPLIMENTED	@ Unimplemented is panic reason
	ldr	pc, 9f			@ Kernel Panic
/* end dispatch_idle */
9:	.word	kernel_panic
