/*  Guantlet/kernel/exception.S
 *  Create by Adam Wiggins: 22/04/1999
 *  Last Modified by Adam Wiggins: 10/10/1999
 *  Generic ARM code for exception entry points less interrupts
 *  (software/hardware)
 */

#include <asm.h>
#include <arm.h>
#include <panic.h>
#include <macros.h>

/* Exception Vectors Table */
VECT(vector_table)
	b	reset_entry		@ Reset entry point 
	b	undefined_dispatch	@ Undefined Instruction dispatcher
	b	soft_int_dispatch	@ Software Interupt dispatcher 
	b	prefetch_abort_dispatch	@ Instruction fetch abort dispatcher
	b	data_abort_dispatch	@ Data abort dispatcher
        nop				@ Reserved
	b	irq_dispatch		@ IRQ dispatcher
					@ FIQ dispatcher follows
/* end vector_table */

/* undefined_dispatch: Undefined instruction exception dispatcher.
 * Pre:                Undefined exception exception Raised in user mode.
 * Post:               IPC generated to threads exception handling thread,
 *                     if exception handling thread doesn't exist current thread
 *                     is terminated.
 * Status:             Not started, for now acts as a nop.
 * Priority:           Do when we get up to exception handling user threads.
 *                     For now it should trap to the kernel debugger. */
EXCP(undefined_dispatch)
	// FILL ME - Generate exception IPC
	mov	r0, #UNIMPLIMENTED	@ Unimplemented is panic reason
	ldr	pc, 9f			@ Kernel Panic
/* end undefined_dispatch */

/* prefetch_abort_dispatch: Instruction fetch abort exception dispatcher.
 * Pre:                     Prefetch abort exception Raised in user mode.
 * Post:                    Abort dispatched to the relavent handler.
 * Registers:               r0 = Current Thread's Kernel Stack Pointer,
 *                          ?
 * Status:                  ?
 * Priority:                ?
/* Fix up this header since its mostly wrong now */
EXCP(prefetch_abort_dispatch)
	mrs	r13, spsr		@ Load SPSR into Temp
	tst	r13, #MODE_MASK		@ Test wether user or kernel abort
	bne	kernel_prefetch_abort	@ if kernel, kernel_prefetch_abort:
/* User generated prefetch abort */
	EXCEPTION_STACK_USER()		@ Stack the aborted kernel state
	// FILL ME
	mov	r0, #UNIMPLIMENTED	@ Unimplimented is panic reason
	ldr	pc, 9f			@ Kernel Panic
/* Kernel generated data abort */
kernel_prefetch_abort:			@ Kernel should never prefetch abort
	mov	r0, #PREFETCH_ABORT	@ Prefetch abort is panic reason
	ldr	pc, 9f			@ Kernel Panic
/* end prefetch_abort_dispatch */
9:	.word	kernel_panic

/* data_abort_dispatch: Data abort exception dispatcher.
 * Pre:                 Data abort exception Rasied.
 * Post:                Abort dispatched to the relavent handler.
 * Registers:           r0 = Current Thread's Kernel Stack Pointer,
 *                      r11 = Fault Address Register,
 *                      r12 = Fault Status Register,
 *                      r13 = Temp.
 * Status:              ?
 * Priority:            ? */
/* Note: this all needs to be fixed up! */
EXCP(data_abort_dispatch)
	mrs	r13, spsr		@ Load SPSR into Temp
	tst	r13, #MODE_MASK		@ Test wether user or kernel abort
	bne	kernel_data_abort	@ if Kernel, kernel_data_abort:
/* User generated data abort */
	EXCEPTION_STACK_USER()		@ Stack the aborted user state
	// FILL ME
	mov	r0, #UNIMPLIMENTED	@ Unimplimented is panic reason
	ldr	pc, 9b			@ Kernel Panic
/* Kernel generated data abort */
kernel_data_abort:
	EXCEPTION_STACK_KERNEL()	@ Stack the aborted kernel state
	RdCP15_FaultStat(r12)		@ Load Fault Status Register into r12
	RdCP15_FaultAddr(r11)		@ Load Fault Address Register into r11
/* Range check the fault */
	cmp	r11, #TCBA_VBASE	@ Compart FAR with start of TCB array
	blt	data_abort_panic	@ If less then panic
/* Find out the reason of the fault */
	and	r13, r12, #STATUS_MASK	@ Mask all but the status from the fsr
	teq	r13, #PERMS_PAGE	@ Test for page permission abort
	bne	1f			@ If not equal try translation aborts
/* Page Permission Abort: Map fresh (zeroed) TCB frame */
	// FILL ME
	mov	r0, #UNIMPLIMENTED	@ Unimplimented is panic reason
	ldr	pc, 9b			@ Kernel Panic
1:	teq	r13, #TRANS_PAGE	@ Test for page translation abort
	bne	2f			@ If not equal try section translation
/* Page Translation Abort: Map Null read only TCB frame */
	// FILL ME
	mov	r0, #UNIMPLIMENTED	@ Unimplimented is panic reason
	ldr	pc, 9b			@ Kernel Panic
2:	teq	r13, #TRANS_SECTION	@ Test for section translation abort
	bne	data_abort_panic	@ If not equal then panic
/* Section Translation Abort: Allocate new page table leaf (check sigma0 first)
	// FILL ME
	mov	r0, UNIMPLIMENTED	@ Unimplimented is panic reason
	ldr	pc, 9b			@ Kernel Panic
/* The Kernel aborted for an invalid reason */
data_abort_panic:
        mov     r0, #DATA_ABORT		@ Data abort is panic reason
        ldr     pc, 9b                  @ Kernel Panic
/* end data_abort_dispatch */
