/*  Gauntlet/kernel/init.h
 *  Created by Adam Wiggins: 14/09/1999
 *  Last Modified by Adam Wiggins: 27/10/1999 
 *  Generic Initialisation defines and macros
 */

#ifndef INIT_H
#define INIT_H

#include <arm.h>
#include <mmu.h>
#include <debug.h>
#include <types.h>
#include <kernel.h>
#include <tcb.h>
#include <platform.h>

/**********
* Externs *
**********/

extern word_t fast_syscall_return[];
extern word_t _end_text[];
extern fld_t cache_page_dir_p[];
extern fld_t cache_page_dir[];
extern kernel_data_t kernel_data[];
extern task_table_t task_table[];
extern tcb_t tcbs[];

/**********************
* Function Prototypes *
**********************/

void main(void) __attribute__ ((section (".init")));
void initMem(void) __attribute__ ((section (".init")));
void initSchedule(void) __attribute__ ((section (".init")));
void initSigma0(void) __attribute__ ((section (".init")));
void initKalloc(void) __attribute__ ((section (".init")));
void initSigma0TCB(void) __attribute__ ((section (".init")));
void freeInit(void) __attribute__ ((section (".init")));
void mapKCDA(void) __attribute__ ((section (".init")));        
void mapNullPage(void) __attribute__ ((section (".init")));
void buildBasePT(void) __attribute__ ((section (".init")));
word_t memSize(void) __attribute__ ((section (".init")));
void mapContRAM(void) __attribute__ ((section (".init")));
void mapKDebug(void) __attribute__ ((section (".init")));
void mapSigma0(void) __attribute__ ((section (".init")));
void mapPlatformIO(void) __attribute__ ((section (".init")));
void initOSTimers(void) __attribute__ ((section (".init")));

/***************************
* Initialisation Constants *
***************************/

#define SIGMA0_INIT_PC 0xC0200000
#define SIGMA0_INIT_SP 0xC0300000


#endif INIT_H
