/*  Gauntlet/kernel/kernel.ld
 *  Created by Adam Wiggins: 13/08/1999
 *  Last Modified by Adam Wiggins: 24/10/1999
 *  Linking script for Gauntlet
 */

INCLUDE symbols.ld
INCLUDE platform.ld

ENTRY(startup)
SECTIONS {
  .excp excp_vaddr : AT (excp_paddr) { 
    _start_excp = .;
    *(.vect .fiqv .excp) 
  }
  _end_excp = .;
  .text text_vaddr : AT (text_paddr) {
    _start_text = .;
    *(.text) 
  }
  _end_text = .;
  .init init_addr : AT (init_addr) {
    _start_init = .;
    *(.init) *(.rodata .data .bss)
  }
  _end_init = .;
  .sigma0 sigma0_addr : AT (sigma0_addr) {
    _start_sigma0 = .;
    *(.sigma0)
  }
  _end_sigma0 = .;
} 
