/*  Gauntlet/kernel/mapping.h
 *  Created by Adam Wiggins: 29/08/1999
 *  Last Modified by Adam Wiggins: 29/08/1999
 *  Mapping Database defines and macros
 */

#ifndef MAPPING_H
#define MAPPING_H

#include <types.h>

/****************
* Mapping Nodes *
****************/

/* 1MB Node */

#ifdef LANGUAGE_C

typedef struct mnode_1MB {
  dword_t task:10;
  dword_t address:12;
  dword_t pad:9;
  dword_t size_next:1;
  dword_t depth:8;
  dword_t next:24;
} mnode_1MB_t;

#endif LANGUAGE_C

/* 64KB Node */

#ifdef LANGUAGE_C

typedef struct mnode_64KB {
  dword_t task:10;
  dword_t address:16;
  dword_t pad:5;
  dword_t size_next:1; 
  dword_t depth:8;
  dword_t next:24;
} mnode_64KB_t;

#endif LANGUAGE_C

/* 4KB Node */

#ifdef LANGUAGE_C

typedef struct mnode_4KB {
  dword_t task:10;
  dword_t address:20;
  dword_t pad:1;
  dword_t size_next:1;
  dword_t depth:8;
  dword_t next:24;
} mnode_4KB_t;

#endif LANGUAGE_C

/* 1KB Node */

#ifdef LANGUAGE_C

typedef struct mnode_1KB {
  dword_t task:10;
  dword_t address:22;
  dword_t depth:8;
  dword_t next:24;
} mnode_1KB_t;

#endif LANGUAGE_C

/**************
* Array Sizes *
**************/

#define FTABLE_MAX     4096 /* Number of frame table entries */
#define MNODE_64KB_MAX 16   /* Number of Nodes in 64KB array under 1MB mapping */
#define MNODE_4KB_MAX  16   /* Number of Nodes in 4KB array under 64KB mapping */
#defien MNODE_1KB_MAX  4    /* Number of Nodes in 1KB array under 4KB mapping */

/********* 
* Macros * 
*********/


#endif MAPPING_H
