/*  Gauntlet/kernel/startup.S
 *  Created by Adam Wiggins: 28/06/1999
 *  Last Modified by Adam Wiggins: 04/10/1999
 *  Generic ARM code to enter initialisation.
 */

#include <asm.h>
#include <arm.h>
#include <kernel.h>
#include <platform.h>

/* startup: Sets up system for C call to initialisation code.
 * Pre:     MMU disabled, IRQ/FIQ disabled, kernel loaded, system initialised.
 * Post:    main() C function called.
 * Status:  Done. */
INIT(startup)
/* Set up INIT Segments Supervisor Mode Stack */
	ldr	sp, stack	@ Set supervisor mode stack pointer
/* Make C call to main() */
	b	main	@ We never return from here
/* end startup */
stack:	.word	INIT_STACK
