/*  Gauntlet/kernel/symbols.ld
 *  Created by Adam Wiggins: 12/09/1999
 *  Last Modified by Adam Wiggins: 03/10/1999
 *  Linking script for definning ARM generic symbols in Gauntlet
 */

/* NOTE: If you change any of these symbols you must make sure that any 
 * #defines are coherent with your changes, there arn't many but some are
 * needed like the address space layout ones */

/* Virtual Memory Map */
null_vbase = 0x00000000; /* 4KB, NULL Page */
user_vbase = 0x00001000; /* 4GB - 256MB - 4KB, User Address Space */
cram_vbase = 0xF0000000; /* 128MB, Contiguous Ram Memory */
psa_vbase  = 0xF8000000; /* 48MB, Platform Specific Area (Unallocated) */
pda_vbase  = 0xFB000000; /* 16MB, Page Directory Array */
tcba_vbase = 0xFC000000; /* 64MB, TCB Virtual Array */ 
kcda_vbase = 0xFFFF0000; /* 64KB, Kernel Code/Data Area */

/* Global Symbols for use in C */
tcbs             = tcba_vbase;
kernel_data      = kcda_vbase + 0xA000;
task_table       = kcda_vbase + 0xB000;
cache_page_dir   = kcda_vbase + 0xC000;
cache_page_dir_p = kcda_pbase + 0xC000;

/* Linker Information */
text_vaddr = kcda_vbase + 0x1000; 
