(*
Copyright (c) 2013, NICTA
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*)

header {* Simple Bitfield Proofs *}

theory simple imports simple_proofs begin

text {* Updating field a preserves field b. *}
lemma (in simple_global_addresses) set_a_preserves:
  "\<forall>s. \<Gamma> \<turnstile> {s}
       \<acute>x :== CALL x_set_a(\<acute>x,\<acute>a)
       \<lbrace> x_CL.b_CL (x_lift \<acute>x) = x_CL.b_CL (x_lift \<^bsup>s\<^esup>x) \<rbrace>"
  by(vcg, auto)

text {* Likewise, updating field b preserves field a. *}
lemma (in simple_global_addresses) set_b_preserves:
  "\<forall>s. \<Gamma> \<turnstile> {s}
       \<acute>x :== CALL x_set_b(\<acute>x,\<acute>b)
       \<lbrace> x_CL.a_CL (x_lift \<acute>x) = x_CL.a_CL (x_lift \<^bsup>s\<^esup>x) \<rbrace>"
  by(vcg, auto)

text {* We can use the function specs to prove the spec for a higher-level function that
  uses them as primitives. *}
lemma (in simple_global_addresses) x_swap_spec:
  "\<forall> s. \<Gamma> \<turnstile> {s}
       \<acute>ret__struct_x_C :== PROC x_swap(\<acute>x)
       \<lbrace> x_lift \<acute>ret__struct_x_C = \<lparr>
          x_CL.a_CL = (x_CL.b_CL (x_lift \<^bsup>s\<^esup>x)),
          x_CL.b_CL = (x_CL.a_CL (x_lift \<^bsup>s\<^esup>x))\<rparr> \<rbrace>"
  by(vcg, simp add:x_lift_def mask_def word_bool_alg.conj.assoc)

text {* We can then show that the spec interacts nicely with the primitive specs. *}
lemma (in simple_global_addresses) swap_test:
  "\<forall> s. \<Gamma> \<turnstile> {s}
       \<acute>x :== CALL x_set_a(\<acute>x, \<acute>a);;
       \<acute>x :== CALL x_swap(\<acute>x);;
       \<acute>b :== CALL x_get_b(\<acute>x)
       \<lbrace> \<acute>b = \<^bsup>s\<^esup>a && mask 16 \<rbrace>"
  by(vcg, auto)

end
